/*
 * Decompiled with CFR 0.152.
 */
package lazy.snad.block;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import lazy.snad.register.ModConfigs;
import lazy.snad.register.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SnadBlock
extends FallingBlock {
    private final int dustColor;

    public SnadBlock(int dustColor, MaterialColor color) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)color).m_60977_().m_60918_(SoundType.f_56746_).m_60978_(0.5f));
        this.dustColor = dustColor;
    }

    @ParametersAreNonnullByDefault
    public int m_6248_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.dustColor;
    }

    @ParametersAreNonnullByDefault
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (plantable.getPlantType(world, pos) == PlantType.DESERT) {
            return true;
        }
        if (plantable.getPlantType(world, pos) == PlantType.BEACH) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                boolean isWater = world.m_6425_(pos.m_142300_(direction)).m_205070_(FluidTags.f_13131_);
                boolean isFrostedIce = world.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50449_);
                if (!isWater && !isFrostedIce) continue;
                return true;
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_7455_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        super.m_7458_(blockState, serverLevel, blockPos, random);
        SnadBlock.snadGrow(serverLevel, blockPos, random);
    }

    public static void snadGrow(ServerLevel serverLevel, BlockPos blockPos, Random random) {
        Block blockAbove = serverLevel.m_8055_(blockPos.m_7494_()).m_60734_();
        if (blockAbove.m_49966_().m_204336_(ModTags.VALID_PLANT)) {
            boolean isSameBlockType = true;
            int height = 1;
            while (isSameBlockType) {
                if (blockPos.m_6630_(height).m_123342_() < 320) {
                    Block nextPlantBlock = serverLevel.m_8055_(blockPos.m_6630_(height)).m_60734_();
                    if (nextPlantBlock.getClass() == blockAbove.getClass()) {
                        for (int growthAttempts = 0; growthAttempts < (Integer)ModConfigs.SPEED.get(); ++growthAttempts) {
                            if (growthAttempts != 0) continue;
                            nextPlantBlock.m_7455_(serverLevel.m_8055_(blockPos.m_6630_(height)), serverLevel, blockPos.m_6630_(height), random);
                        }
                        ++height;
                        continue;
                    }
                    isSameBlockType = false;
                    continue;
                }
                isSameBlockType = false;
            }
        }
    }
}

